// ddmenu.js
// Genie drop-down menu system
// Version: 3.2

// INITIALISATION ///////////
// globals
var br = null;
var theVersion = 0;
var blnOverMenu = false;
var strCSSMenuBox = "";
var strCSSTooltipBox = "";
var theStyle = "";
var timeOutID = null;

// detect browser type
//alert(navigator.appVersion);
theVersion = parseInt(navigator.appVersion);
if (navigator.appName == "Netscape")
	br = "N";
else
	br = "IE";

if (br == "N") window.onLoad = setResize();

// setup 'event' object for Netscape
if (!window.event && window.captureEvents) {
	window.captureEvents(Event.MOUSEMOVE);
	window.onmousemove = getCursorHandler;
	window.onclick = getCursorHandler;
	window.event = new Object;
}

// write styles into document
strCSSMenuBox += ".ddmMenuBox {";
strCSSMenuBox += "   background-color: #46b82f;";
strCSSMenuBox += "   padding-left: 4px;";
strCSSMenuBox += "   padding-right: 6px;";
strCSSMenuBox += "   border-style: solid;";
strCSSMenuBox += "   border-width: 1px 1px 1px 1px;";
strCSSMenuBox += "   border-color: #336600;";
if (br == "IE" || theVersion >= 5) {
	strCSSMenuBox += "   position: absolute;";
	strCSSMenuBox += "   visibility: hidden;";
}
strCSSMenuBox += "}";

strCSSTooltipBox += ".ddmTooltipBox {";
strCSSTooltipBox += "   background-color: #FFFFCC;"
strCSSTooltipBox += "   padding-left: 4px;";
strCSSTooltipBox += "   padding-right: 6px;";
strCSSTooltipBox += "   border-style: solid;";
strCSSTooltipBox += "   border-width: 1px 1px 1px 1px;";
strCSSTooltipBox += "   border-color: #336600;";
if (br == "IE" || theVersion >= 5) {
	strCSSTooltipBox += "   position: absolute;";
	strCSSTooltipBox += "   visibility: hidden;";
}
strCSSTooltipBox += "}";

document.writeln("<style type=text/css>");
document.writeln(strCSSMenuBox);
document.writeln(strCSSTooltipBox);
document.writeln("</style>");

// FUNCTION DEFINITIONS /////
function reDo() { window.location.reload(); }

function setResize() { setTimeout("window.onResize=reDo", 5000); }

function getCursorHandler(e) {
	window.event.offsetX = e.pageX;
	window.event.offsetY = e.pageY;
	window.event.srcElement = e.target;
	// route the event back to the intended function
	if (routeEvent(e) == false) return false;
	else return true;
}

function MenuItem(strLabel, strLink, strTarget) {
	this.strLabel = strLabel;
	this.strLink = strLink;
	this.strTarget = strTarget;
}

function Menu(strID, intLeft, intTop, objMenuItems) {
	this.objMenuItems = objMenuItems;
	this.strID = strID;
	this.intLeft = intLeft;
	this.intTop = intTop;

	buildBoxStartTag(strID);
	for (var i=0; i < objMenuItems.length; i++)
		if (objMenuItems[i].strLink != "")
			document.write("<a class=\"ddmMenuItem\" href='" + objMenuItems[i].strLink + "'" + objMenuItems[i].strTarget + ">" + objMenuItems[i].strLabel + "</a><br>");
		else
			document.write(objMenuItems[i].strLabel);		
	buildBoxEndTag();
}

function buildBoxStartTag(strID) {
	theStyle = "ddmMenuBox";
	
	if (br == "IE" || theVersion >= 5){
		document.write("<div id=\"" + strID + "\" onMouseOver=\"blnOverMenu = true;\" onMouseOut=\"hideMenu(200);\" class=\"" + theStyle + "\">");
	} else {
		document.write("<layer id=\"" + strID + "\" bgcolor=#FFFFFF clip=\"auto auto auto auto\" visibility=hidden onMouseOver=\"blnOverMenu = true;\" onMouseOut=\"moveOffMenu(\'" + strID + "\');\" class=\"" + theStyle + "\">");
	}
}

function buildBoxEndTag() {
	(br == "IE" || theVersion >= 5) ? document.write("</div>") : document.write("</layer>");
}

function findXPos(objEl) {
	var intX = objEl.offsetLeft;
	while (objEl.offsetParent) {
		objEl = objEl.offsetParent;
		intX += objEl.offsetLeft;
	}
	return intX;
}

function findYPos(objEl) {
	var intY = objEl.offsetTop;
	while (objEl.offsetParent) {
		objEl = objEl.offsetParent;
		intY += objEl.offsetTop;
	}
	return intY;
}

function showMenu(strID) {
	clearTimeout(timeOutID);
	hideAll();
	if (br == "N"){
		if(strID == "menu0b"||strID == "menu1b"){
			return false;
		}
	} else if(strID == "menu0b"){
		strID = "menu0";
	} else if(strID == "menu1b"){
		strID = "menu1";
	}
		
	var intLnkTop, intLnkLeft, intLnkWidth, intLnkHeight;
	var objLink = window.event.srcElement;
	
	blnOverMenu = true;	
	if (br == "IE") {
		objBox = window.document.getElementById(strID).style;
		intLnkTop = findYPos(objLink);
		intLnkLeft = findXPos(objLink);
		intLnkWidth = objLink.offsetWidth;
		intLnkHeight = objLink.offsetHeight;
	}
	else {
		for (var i=0; i < menuTree.length; i++)
			if (menuTree[i].strID == strID) {
				intLnkTop = menuTree[i].intTop;
				intLnkLeft = menuTree[i].intLeft;
			}
		if(theVersion < 5){
			objBox = window.document.layers[strID];
		} else {
			objBox = window.document.getElementById(strID);
		}
	}
	if(br == "N" && theVersion >= 5){
		objBox.style.top = intLnkTop;
		objBox.style.left = intLnkLeft;
		objBox.style.width = 100;
		objBox.style.visibility = "visible";
	} else {
		objBox.top = (br == "IE") ? (intLnkTop + intLnkHeight + 2) : intLnkTop;
		objBox.left = (intLnkLeft > 9) ? (intLnkLeft - 5) : 0;
		objBox.width = (intLnkLeft > 9) ? (intLnkWidth + 10) : (intLnkWidth + 5);
		objBox.visibility = "visible";
	}
	hideMenu(2000);
}

function hideAll() {
	if (!blnOverMenu)
		for (var i=0; i < menuTree.length; i++)
			(br == "IE" || theVersion >= 5) ? document.getElementById([menuTree[i].strID]).style.visibility = "hidden" : window.document[menuTree[i].strID].visibility = "hidden";			
}

function hideMenu(delay) {
	blnOverMenu = false;
	timeOutID = setTimeout("hideAll()", delay);
}

function moveOffMenu(strID) {
	var intTop, intLeft, intBott, intRight;
	
	if (br == "N" && theVersion < 5) {
		objDiv = window.document.layers[strID];
		intTop = objDiv.y + 2;
		intLeft = objDiv.x + 2;
		intBott = intTop + objDiv.clip.height - 4;
		intRight = intLeft + objDiv.clip.width - 4;
	}
	else if (br == "IE" || theVersion >= 5) {
		objDiv = document.getElementById(strID);
		intTop = objDiv.offsetTop + 2;
		intLeft = objDiv.offsetLeft + 2;
		intBott = intTop + objDiv.clientHeight - 4;
		intRight = intLeft + objDiv.clientWidth - 4;
	}
	if (window.event.offsetY < intTop || window.event.offsetY > intBott ||
		window.event.offsetX < intLeft || window.event.offsetX > intRight)
		hideMenu(200);
}
